/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef HODJNPODJ_WORDSEARCH_WORDLIST_H
#define HODJNPODJ_WORDSEARCH_WORDLIST_H

#include "bagel/afxwin.h"

namespace Bagel {
namespace HodjNPodj {
namespace WordSearch {

#define     WORDSPERLIST    25
#define     NUMBEROFLISTS   50

#define TEXT_COLOR          RGB(0, 0, 0)        // found word text color
#define UNFOUND_COLOR       RGB(0, 167, 200)        // Still not found words color
#define DK_CYAN             RGB(0, 167, 255)        // Still not found words color
#define DK_SKY              RGB(0, 67, 160)     // Still not found words color
#define RED_TEXT            RGB(226, 28, 21)        // Still not found words color

} // namespace Poker
} // namespace HodjNPodj
} // namespace Bagel

#endif
