/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Place {
    /// name of the transit stop / PoI / address
    #[serde(rename = "name")]
    pub name: String,
    /// The ID of the stop. This is often something that users don't care about.
    #[serde(rename = "stopId", skip_serializing_if = "Option::is_none")]
    pub stop_id: Option<String>,
    /// The importance of the stop between 0-1.
    #[serde(rename = "importance", skip_serializing_if = "Option::is_none")]
    pub importance: Option<f64>,
    /// latitude
    #[serde(rename = "lat")]
    pub lat: f64,
    /// longitude
    #[serde(rename = "lon")]
    pub lon: f64,
    /// level according to OpenStreetMap
    #[serde(rename = "level")]
    pub level: f64,
    /// timezone name (e.g. \"Europe/Berlin\")
    #[serde(rename = "tz", skip_serializing_if = "Option::is_none")]
    pub tz: Option<String>,
    /// arrival time
    #[serde(rename = "arrival", skip_serializing_if = "Option::is_none")]
    pub arrival: Option<String>,
    /// departure time
    #[serde(rename = "departure", skip_serializing_if = "Option::is_none")]
    pub departure: Option<String>,
    /// scheduled arrival time
    #[serde(rename = "scheduledArrival", skip_serializing_if = "Option::is_none")]
    pub scheduled_arrival: Option<String>,
    /// scheduled departure time
    #[serde(rename = "scheduledDeparture", skip_serializing_if = "Option::is_none")]
    pub scheduled_departure: Option<String>,
    /// scheduled track from the static schedule timetable dataset
    #[serde(rename = "scheduledTrack", skip_serializing_if = "Option::is_none")]
    pub scheduled_track: Option<String>,
    /// The current track/platform information, updated with real-time updates if available.  Can be missing if neither real-time updates nor the schedule timetable contains track information. 
    #[serde(rename = "track", skip_serializing_if = "Option::is_none")]
    pub track: Option<String>,
    /// description of the location that provides more detailed information
    #[serde(rename = "description", skip_serializing_if = "Option::is_none")]
    pub description: Option<String>,
    #[serde(rename = "vertexType", skip_serializing_if = "Option::is_none")]
    pub vertex_type: Option<models::VertexType>,
    /// Type of pickup. It could be disallowed due to schedule, skipped stops or cancellations.
    #[serde(rename = "pickupType", skip_serializing_if = "Option::is_none")]
    pub pickup_type: Option<models::PickupDropoffType>,
    /// Type of dropoff. It could be disallowed due to schedule, skipped stops or cancellations.
    #[serde(rename = "dropoffType", skip_serializing_if = "Option::is_none")]
    pub dropoff_type: Option<models::PickupDropoffType>,
    /// Whether this stop is cancelled due to the realtime situation.
    #[serde(rename = "cancelled", skip_serializing_if = "Option::is_none")]
    pub cancelled: Option<bool>,
    /// Alerts for this stop.
    #[serde(rename = "alerts", skip_serializing_if = "Option::is_none")]
    pub alerts: Option<Vec<models::Alert>>,
    /// for `FLEX` transports, the flex location area or location group name
    #[serde(rename = "flex", skip_serializing_if = "Option::is_none")]
    pub flex: Option<String>,
    /// for `FLEX` transports, the flex location area ID or location group ID
    #[serde(rename = "flexId", skip_serializing_if = "Option::is_none")]
    pub flex_id: Option<String>,
    /// Time that on-demand service becomes available
    #[serde(rename = "flexStartPickupDropOffWindow", skip_serializing_if = "Option::is_none")]
    pub flex_start_pickup_drop_off_window: Option<String>,
    /// Time that on-demand service ends
    #[serde(rename = "flexEndPickupDropOffWindow", skip_serializing_if = "Option::is_none")]
    pub flex_end_pickup_drop_off_window: Option<String>,
}

impl Place {
    pub fn new(name: String, lat: f64, lon: f64, level: f64) -> Place {
        Place {
            name,
            stop_id: None,
            importance: None,
            lat,
            lon,
            level,
            tz: None,
            arrival: None,
            departure: None,
            scheduled_arrival: None,
            scheduled_departure: None,
            scheduled_track: None,
            track: None,
            description: None,
            vertex_type: None,
            pickup_type: None,
            dropoff_type: None,
            cancelled: None,
            alerts: None,
            flex: None,
            flex_id: None,
            flex_start_pickup_drop_off_window: None,
            flex_end_pickup_drop_off_window: None,
        }
    }
}

