% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{mwText}
\alias{mwText}
\title{Add a text input to a manipulateWidget gadget}
\usage{
mwText(value = "", label = NULL, ..., .display = TRUE)
}
\arguments{
\item{value}{Initial value of the text input.}

\item{label}{Display label for the control. If \code{NULL}, the name of the corresponding
variable is used.}

\item{...}{Other arguments passed to function\code{\link[shiny]{textInput}}}

\item{.display}{expression that evaluates to TRUE or FALSE, indicating when
the input control should be shown/hidden.}
}
\value{
A function that will generate the input control.
}
\description{
Add a text input to a manipulateWidget gadget
}
\examples{
if (require(plotly)) {
  mydata <- data.frame(x = 1:100, y = rnorm(100))
  manipulateWidget({
      plot_ly(mydata, x=~x, y=~y, type = "scatter", mode = "markers") \%>\%
        layout(title = mytitle)
    },
    mytitle = mwText("Awesome title !")
  )
}

}
\seealso{
Other controls: 
\code{\link{mwCheckboxGroup}()},
\code{\link{mwCheckbox}()},
\code{\link{mwDateRange}()},
\code{\link{mwDate}()},
\code{\link{mwGroup}()},
\code{\link{mwNumeric}()},
\code{\link{mwPassword}()},
\code{\link{mwRadio}()},
\code{\link{mwSelectize}()},
\code{\link{mwSelect}()},
\code{\link{mwSharedValue}()},
\code{\link{mwSlider}()}
}
\concept{controls}
