% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{edge.betweenness}
\alias{edge.betweenness}
\title{Vertex and edge betweenness centrality}
\usage{
edge.betweenness(
  graph,
  e = E(graph),
  directed = TRUE,
  weights = NULL,
  cutoff = -1
)
}
\arguments{
\item{graph}{The graph to analyze.}

\item{e}{The edges for which the edge betweenness will be calculated.}

\item{directed}{Logical, whether directed paths should be considered while
determining the shortest paths.}

\item{weights}{Optional positive weight vector for calculating weighted
betweenness. If the graph has a \code{weight} edge attribute, then this is
used by default. Weights are used to calculate weighted shortest paths,
so they are interpreted as distances.}

\item{cutoff}{The maximum shortest path length to consider when calculating
betweenness. If negative, then there is no such limit.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{edge.betweenness()} was renamed to \code{\link[=edge_betweenness]{edge_betweenness()}} to create a more
consistent API.
}
\keyword{internal}
