% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{align_layout}
\alias{align_layout}
\title{Align a vertex layout
This function centers a vertex layout on the coordinate system origin and
rotates the layout to achieve a visually pleasing alignment with the coordinate
axes. Doing this is particularly useful with force-directed layouts such as \code{\link[=layout_with_fr]{layout_with_fr()}}.}
\usage{
align_layout(graph, layout)
}
\arguments{
\item{graph}{The graph whose layout is to be aligned.}

\item{layout}{A matrix whose rows are the coordinates of vertices.}
}
\value{
modified layout matrix
}
\description{
Align a vertex layout
This function centers a vertex layout on the coordinate system origin and
rotates the layout to achieve a visually pleasing alignment with the coordinate
axes. Doing this is particularly useful with force-directed layouts such as \code{\link[=layout_with_fr]{layout_with_fr()}}.
}
\examples{
g <- make_lattice(c(3, 3))
l1 <- layout_with_fr(g)
l2 <- align_layout(g,l1)
plot(g, layout = l1)
plot(g, layout = l2)
}
