# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.loadtesting.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class CheckQuotaAvailabilityResponse(Resource):
    """Check quota availability response object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.loadtesting.models.SystemData
    :ivar is_available: True/False indicating whether the quota request be granted based on
     availability.
    :vartype is_available: bool
    :ivar availability_status: Message indicating additional details to add to quota support
     request.
    :vartype availability_status: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "is_available": {"key": "properties.isAvailable", "type": "bool"},
        "availability_status": {"key": "properties.availabilityStatus", "type": "str"},
    }

    def __init__(
        self, *, is_available: Optional[bool] = None, availability_status: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword is_available: True/False indicating whether the quota request be granted based on
         availability.
        :paramtype is_available: bool
        :keyword availability_status: Message indicating additional details to add to quota support
         request.
        :paramtype availability_status: str
        """
        super().__init__(**kwargs)
        self.is_available = is_available
        self.availability_status = availability_status


class EncryptionProperties(_serialization.Model):
    """Key and identity details for Customer Managed Key encryption of load test resource.

    :ivar identity: All identity configuration for Customer-managed key settings defining which
     identity should be used to auth to Key Vault.
    :vartype identity: ~azure.mgmt.loadtesting.models.EncryptionPropertiesIdentity
    :ivar key_url: key encryption key Url, versioned. Ex:
     https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or
     https://contosovault.vault.azure.net/keys/contosokek.
    :vartype key_url: str
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "EncryptionPropertiesIdentity"},
        "key_url": {"key": "keyUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.EncryptionPropertiesIdentity"] = None,
        key_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: All identity configuration for Customer-managed key settings defining which
         identity should be used to auth to Key Vault.
        :paramtype identity: ~azure.mgmt.loadtesting.models.EncryptionPropertiesIdentity
        :keyword key_url: key encryption key Url, versioned. Ex:
         https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78 or
         https://contosovault.vault.azure.net/keys/contosokek.
        :paramtype key_url: str
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.key_url = key_url


class EncryptionPropertiesIdentity(_serialization.Model):
    """All identity configuration for Customer-managed key settings defining which identity should be
    used to auth to Key Vault.

    :ivar type: Managed identity type to use for accessing encryption key Url. Known values are:
     "SystemAssigned" and "UserAssigned".
    :vartype type: str or ~azure.mgmt.loadtesting.models.Type
    :ivar resource_id: user assigned identity to use for accessing key encryption key Url. Ex:
     /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/:code:`<resource
     group>`/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
    :vartype resource_id: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(
        self, *, type: Optional[Union[str, "_models.Type"]] = None, resource_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: Managed identity type to use for accessing encryption key Url. Known values are:
         "SystemAssigned" and "UserAssigned".
        :paramtype type: str or ~azure.mgmt.loadtesting.models.Type
        :keyword resource_id: user assigned identity to use for accessing key encryption key Url. Ex:
         /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/:code:`<resource
         group>`/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.resource_id = resource_id


class EndpointDependency(_serialization.Model):
    """A domain name and connection details used to access a dependency.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar domain_name: The domain name of the dependency. Domain names may be fully qualified or
     may contain a * wildcard.
    :vartype domain_name: str
    :ivar description: Human-readable supplemental information about the dependency and when it is
     applicable.
    :vartype description: str
    :ivar endpoint_details: The list of connection details for this endpoint.
    :vartype endpoint_details: list[~azure.mgmt.loadtesting.models.EndpointDetail]
    """

    _validation = {
        "domain_name": {"readonly": True},
        "description": {"readonly": True},
        "endpoint_details": {"readonly": True},
    }

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "endpoint_details": {"key": "endpointDetails", "type": "[EndpointDetail]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.domain_name = None
        self.description = None
        self.endpoint_details = None


class EndpointDetail(_serialization.Model):
    """Details about the connection between the Batch service and the endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    """

    _validation = {
        "port": {"readonly": True},
    }

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.port = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.loadtesting.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.loadtesting.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.loadtesting.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.loadtesting.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.loadtesting.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class LoadTestResource(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """LoadTest details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.loadtesting.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The type of identity used for the resource.
    :vartype identity: ~azure.mgmt.loadtesting.models.ManagedServiceIdentity
    :ivar description: Description of the resource.
    :vartype description: str
    :ivar provisioning_state: Resource provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.loadtesting.models.ResourceState
    :ivar data_plane_uri: Resource data plane URI.
    :vartype data_plane_uri: str
    :ivar encryption: CMK Encryption property.
    :vartype encryption: ~azure.mgmt.loadtesting.models.EncryptionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "description": {"max_length": 512},
        "provisioning_state": {"readonly": True},
        "data_plane_uri": {"readonly": True, "max_length": 2083},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "description": {"key": "properties.description", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "data_plane_uri": {"key": "properties.dataPlaneURI", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "EncryptionProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        description: Optional[str] = None,
        encryption: Optional["_models.EncryptionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The type of identity used for the resource.
        :paramtype identity: ~azure.mgmt.loadtesting.models.ManagedServiceIdentity
        :keyword description: Description of the resource.
        :paramtype description: str
        :keyword encryption: CMK Encryption property.
        :paramtype encryption: ~azure.mgmt.loadtesting.models.EncryptionProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.description = description
        self.provisioning_state = None
        self.data_plane_uri = None
        self.encryption = encryption


class LoadTestResourcePageList(_serialization.Model):
    """List of resources page result.

    :ivar value: List of resources in current page.
    :vartype value: list[~azure.mgmt.loadtesting.models.LoadTestResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadTestResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.LoadTestResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of resources in current page.
        :paramtype value: list[~azure.mgmt.loadtesting.models.LoadTestResource]
        :keyword next_link: Link to next page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LoadTestResourcePatchRequestBody(_serialization.Model):
    """LoadTest resource patch request body.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The type of identity used for the resource.
    :vartype identity: ~azure.mgmt.loadtesting.models.ManagedServiceIdentity
    :ivar description: Description of the resource.
    :vartype description: str
    :ivar encryption: CMK Encryption property.
    :vartype encryption: ~azure.mgmt.loadtesting.models.EncryptionProperties
    """

    _validation = {
        "description": {"max_length": 512},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "description": {"key": "properties.description", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "EncryptionProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        description: Optional[str] = None,
        encryption: Optional["_models.EncryptionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The type of identity used for the resource.
        :paramtype identity: ~azure.mgmt.loadtesting.models.ManagedServiceIdentity
        :keyword description: Description of the resource.
        :paramtype description: str
        :keyword encryption: CMK Encryption property.
        :paramtype encryption: ~azure.mgmt.loadtesting.models.EncryptionProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.description = description
        self.encryption = encryption


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.loadtesting.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.loadtesting.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.loadtesting.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.loadtesting.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.loadtesting.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.loadtesting.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.loadtesting.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.loadtesting.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.loadtesting.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OutboundEnvironmentEndpoint(_serialization.Model):
    """A collection of related endpoints from the same service for which the Batch service requires
    outbound access.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar category: The type of service that Azure Load Testing connects to.
    :vartype category: str
    :ivar endpoints: The endpoints for this service to which the Batch service makes outbound
     calls.
    :vartype endpoints: list[~azure.mgmt.loadtesting.models.EndpointDependency]
    """

    _validation = {
        "category": {"readonly": True},
        "endpoints": {"readonly": True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[EndpointDependency]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.category = None
        self.endpoints = None


class OutboundEnvironmentEndpointCollection(_serialization.Model):
    """Values returned by the List operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The collection of outbound network dependency endpoints returned by the listing
     operation.
    :vartype value: list[~azure.mgmt.loadtesting.models.OutboundEnvironmentEndpoint]
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundEnvironmentEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The continuation token.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class QuotaBucketRequest(Resource):
    """Request object of new quota for a quota bucket.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.loadtesting.models.SystemData
    :ivar current_usage: Current quota usage of the quota bucket.
    :vartype current_usage: int
    :ivar current_quota: Current quota limit of the quota bucket.
    :vartype current_quota: int
    :ivar new_quota: New quota limit of the quota bucket.
    :vartype new_quota: int
    :ivar dimensions: Dimensions for new quota request.
    :vartype dimensions: ~azure.mgmt.loadtesting.models.QuotaBucketRequestPropertiesDimensions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "current_usage": {"minimum": 0},
        "current_quota": {"minimum": 0},
        "new_quota": {"minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "current_usage": {"key": "properties.currentUsage", "type": "int"},
        "current_quota": {"key": "properties.currentQuota", "type": "int"},
        "new_quota": {"key": "properties.newQuota", "type": "int"},
        "dimensions": {"key": "properties.dimensions", "type": "QuotaBucketRequestPropertiesDimensions"},
    }

    def __init__(
        self,
        *,
        current_usage: Optional[int] = None,
        current_quota: Optional[int] = None,
        new_quota: Optional[int] = None,
        dimensions: Optional["_models.QuotaBucketRequestPropertiesDimensions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword current_usage: Current quota usage of the quota bucket.
        :paramtype current_usage: int
        :keyword current_quota: Current quota limit of the quota bucket.
        :paramtype current_quota: int
        :keyword new_quota: New quota limit of the quota bucket.
        :paramtype new_quota: int
        :keyword dimensions: Dimensions for new quota request.
        :paramtype dimensions: ~azure.mgmt.loadtesting.models.QuotaBucketRequestPropertiesDimensions
        """
        super().__init__(**kwargs)
        self.current_usage = current_usage
        self.current_quota = current_quota
        self.new_quota = new_quota
        self.dimensions = dimensions


class QuotaBucketRequestPropertiesDimensions(_serialization.Model):
    """Dimensions for new quota request.

    :ivar subscription_id: Subscription Id dimension for new quota request of the quota bucket.
    :vartype subscription_id: str
    :ivar location: Location dimension for new quota request of the quota bucket.
    :vartype location: str
    """

    _validation = {
        "subscription_id": {"min_length": 1},
        "location": {"min_length": 1},
    }

    _attribute_map = {
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, subscription_id: Optional[str] = None, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword subscription_id: Subscription Id dimension for new quota request of the quota bucket.
        :paramtype subscription_id: str
        :keyword location: Location dimension for new quota request of the quota bucket.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.subscription_id = subscription_id
        self.location = location


class QuotaResource(Resource):
    """Quota bucket details object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.loadtesting.models.SystemData
    :ivar limit: Current quota limit of the quota bucket.
    :vartype limit: int
    :ivar usage: Current quota usage of the quota bucket.
    :vartype usage: int
    :ivar provisioning_state: Resource provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.loadtesting.models.ResourceState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "limit": {"minimum": 0},
        "usage": {"minimum": 0},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "limit": {"key": "properties.limit", "type": "int"},
        "usage": {"key": "properties.usage", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, limit: Optional[int] = None, usage: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword limit: Current quota limit of the quota bucket.
        :paramtype limit: int
        :keyword usage: Current quota usage of the quota bucket.
        :paramtype usage: int
        """
        super().__init__(**kwargs)
        self.limit = limit
        self.usage = usage
        self.provisioning_state = None


class QuotaResourceList(_serialization.Model):
    """List of quota bucket objects. It contains a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of quota bucket objects provided by the loadtestservice.
    :vartype value: list[~azure.mgmt.loadtesting.models.QuotaResource]
    :ivar next_link: URL to get the next set of quota bucket objects results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[QuotaResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.loadtesting.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.loadtesting.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.loadtesting.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.loadtesting.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
