#ifndef RND_HID_MBTK_CONF_H
#define RND_HID_MBTK_CONF_H

#include <librnd/core/conf.h>

typedef struct {
	const struct {
		const struct {
			RND_CFT_BOOLEAN listen;                          /* @usage Listen for actions on stdin. */

			RND_CFT_REAL icon_scale;                         /* scale icon buttons and icons by this factor (normal size = 1); need restart to apply */

			const struct {
				RND_CFT_BOOLEAN transient_modal;              /* modal dialogs are transient to the main window */
				RND_CFT_BOOLEAN transient_modeless;           /* modeless dialogs are transient to the main window */
				RND_CFT_BOOLEAN auto_present;                 /* present (pop up to the top) new dialogs automatically */
			} dialog;

			const struct {
				RND_CFT_STRING  fg_red;                       /* foreground color to be used with <red> text in markup */
				RND_CFT_STRING  fg_green;                     /* foreground color to be used with <green> text in markup */
				RND_CFT_STRING  fg_blue;                      /* foreground color to be used with <blue> text in markup */
			} markup;
		} hid_mbtk;
	} plugins;
} conf_lib_mbtk_t;

extern conf_lib_mbtk_t rnd_mbtk_conf;

#endif
