//go:build !linux
// +build !linux

package unix

const (
	AF_INET                                    = 0x2
	AF_INET6                                   = 0xa
	AF_UNSPEC                                  = 0x0
	NETLINK_ROUTE                              = 0x0
	SizeofIfAddrmsg                            = 0x8
	SizeofIfInfomsg                            = 0x10
	SizeofNdMsg                                = 0xc
	SizeofRtMsg                                = 0xc
	SizeofRtNexthop                            = 0x8
	RTM_NEWADDR                                = 0x14
	RTM_DELADDR                                = 0x15
	RTM_GETADDR                                = 0x16
	RTM_NEWLINK                                = 0x10
	RTM_DELLINK                                = 0x11
	RTM_GETLINK                                = 0x12
	RTM_SETLINK                                = 0x13
	RTM_NEWROUTE                               = 0x18
	RTM_DELROUTE                               = 0x19
	RTM_GETROUTE                               = 0x1a
	RTM_NEWNEIGH                               = 0x1c
	RTM_DELNEIGH                               = 0x1d
	RTM_GETNEIGH                               = 0x1e
	IFA_UNSPEC                                 = 0x0
	IFA_ADDRESS                                = 0x1
	IFA_LOCAL                                  = 0x2
	IFA_LABEL                                  = 0x3
	IFA_BROADCAST                              = 0x4
	IFA_ANYCAST                                = 0x5
	IFA_CACHEINFO                              = 0x6
	IFA_MULTICAST                              = 0x7
	IFA_FLAGS                                  = 0x8
	IFA_RT_PRIORITY                            = 0x9
	IFF_UP                                     = 0x1
	IFF_BROADCAST                              = 0x2
	IFF_LOOPBACK                               = 0x8
	IFF_POINTOPOINT                            = 0x10
	IFF_MULTICAST                              = 0x1000
	IFLA_UNSPEC                                = 0x0
	IFLA_ADDRESS                               = 0x1
	IFLA_BR_UNSPEC                             = 0x0
	IFLA_BR_FORWARD_DELAY                      = 0x1
	IFLA_BR_HELLO_TIME                         = 0x2
	IFLA_BR_MAX_AGE                            = 0x3
	IFLA_BR_AGEING_TIME                        = 0x4
	IFLA_BR_STP_STATE                          = 0x5
	IFLA_BR_PRIORITY                           = 0x6
	IFLA_BR_VLAN_FILTERING                     = 0x7
	IFLA_BR_VLAN_PROTOCOL                      = 0x8
	IFLA_BR_GROUP_FWD_MASK                     = 0x9
	IFLA_BR_ROOT_ID                            = 0xa
	IFLA_BR_BRIDGE_ID                          = 0xb
	IFLA_BR_ROOT_PORT                          = 0xc
	IFLA_BR_ROOT_PATH_COST                     = 0xd
	IFLA_BR_TOPOLOGY_CHANGE                    = 0xe
	IFLA_BR_TOPOLOGY_CHANGE_DETECTED           = 0xf
	IFLA_BR_HELLO_TIMER                        = 0x10
	IFLA_BR_TCN_TIMER                          = 0x11
	IFLA_BR_TOPOLOGY_CHANGE_TIMER              = 0x12
	IFLA_BR_GC_TIMER                           = 0x13
	IFLA_BR_GROUP_ADDR                         = 0x14
	IFLA_BR_FDB_FLUSH                          = 0x15
	IFLA_BR_MCAST_ROUTER                       = 0x16
	IFLA_BR_MCAST_SNOOPING                     = 0x17
	IFLA_BR_MCAST_QUERY_USE_IFADDR             = 0x18
	IFLA_BR_MCAST_QUERIER                      = 0x19
	IFLA_BR_MCAST_HASH_ELASTICITY              = 0x1a
	IFLA_BR_MCAST_HASH_MAX                     = 0x1b
	IFLA_BR_MCAST_LAST_MEMBER_CNT              = 0x1c
	IFLA_BR_MCAST_STARTUP_QUERY_CNT            = 0x1d
	IFLA_BR_MCAST_LAST_MEMBER_INTVL            = 0x1e
	IFLA_BR_MCAST_MEMBERSHIP_INTVL             = 0x1f
	IFLA_BR_MCAST_QUERIER_INTVL                = 0x20
	IFLA_BR_MCAST_QUERY_INTVL                  = 0x21
	IFLA_BR_MCAST_QUERY_RESPONSE_INTVL         = 0x22
	IFLA_BR_MCAST_STARTUP_QUERY_INTVL          = 0x23
	IFLA_BR_NF_CALL_IPTABLES                   = 0x24
	IFLA_BR_NF_CALL_IP6TABLES                  = 0x25
	IFLA_BR_NF_CALL_ARPTABLES                  = 0x26
	IFLA_BR_VLAN_DEFAULT_PVID                  = 0x27
	IFLA_BR_PAD                                = 0x28
	IFLA_BR_VLAN_STATS_ENABLED                 = 0x29
	IFLA_BR_MCAST_STATS_ENABLED                = 0x2a
	IFLA_BR_MCAST_IGMP_VERSION                 = 0x2b
	IFLA_BR_MCAST_MLD_VERSION                  = 0x2c
	IFLA_BR_VLAN_STATS_PER_PORT                = 0x2d
	IFLA_BR_MULTI_BOOLOPT                      = 0x2e
	IFLA_BR_MCAST_QUERIER_STATE                = 0x2f
	IFLA_BR_FDB_N_LEARNED                      = 0x30
	IFLA_BR_FDB_MAX_LEARNED                    = 0x31
	IFLA_BRPORT_UNSPEC                         = 0x0
	IFLA_BRPORT_STATE                          = 0x1
	IFLA_BRPORT_PRIORITY                       = 0x2
	IFLA_BRPORT_COST                           = 0x3
	IFLA_BRPORT_MODE                           = 0x4
	IFLA_BRPORT_GUARD                          = 0x5
	IFLA_BRPORT_PROTECT                        = 0x6
	IFLA_BRPORT_FAST_LEAVE                     = 0x7
	IFLA_BRPORT_LEARNING                       = 0x8
	IFLA_BRPORT_UNICAST_FLOOD                  = 0x9
	IFLA_BRPORT_PROXYARP                       = 0xa
	IFLA_BRPORT_LEARNING_SYNC                  = 0xb
	IFLA_BRPORT_PROXYARP_WIFI                  = 0xc
	IFLA_BRPORT_ROOT_ID                        = 0xd
	IFLA_BRPORT_BRIDGE_ID                      = 0xe
	IFLA_BRPORT_DESIGNATED_PORT                = 0xf
	IFLA_BRPORT_DESIGNATED_COST                = 0x10
	IFLA_BRPORT_ID                             = 0x11
	IFLA_BRPORT_NO                             = 0x12
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK            = 0x13
	IFLA_BRPORT_CONFIG_PENDING                 = 0x14
	IFLA_BRPORT_MESSAGE_AGE_TIMER              = 0x15
	IFLA_BRPORT_FORWARD_DELAY_TIMER            = 0x16
	IFLA_BRPORT_HOLD_TIMER                     = 0x17
	IFLA_BRPORT_FLUSH                          = 0x18
	IFLA_BRPORT_MULTICAST_ROUTER               = 0x19
	IFLA_BRPORT_PAD                            = 0x1a
	IFLA_BRPORT_MCAST_FLOOD                    = 0x1b
	IFLA_BRPORT_MCAST_TO_UCAST                 = 0x1c
	IFLA_BRPORT_VLAN_TUNNEL                    = 0x1d
	IFLA_BRPORT_BCAST_FLOOD                    = 0x1e
	IFLA_BRPORT_GROUP_FWD_MASK                 = 0x1f
	IFLA_BRPORT_NEIGH_SUPPRESS                 = 0x20
	IFLA_BRPORT_ISOLATED                       = 0x21
	IFLA_BRPORT_BACKUP_PORT                    = 0x22
	IFLA_BRPORT_MRP_RING_OPEN                  = 0x23
	IFLA_BRPORT_MRP_IN_OPEN                    = 0x24
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT          = 0x25
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT            = 0x26
	IFLA_BRPORT_LOCKED                         = 0x27
	IFLA_BRPORT_MAB                            = 0x28
	IFLA_BRPORT_MCAST_N_GROUPS                 = 0x29
	IFLA_BRPORT_MCAST_MAX_GROUPS               = 0x2a
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS            = 0x2b
	IFLA_BRPORT_BACKUP_NHID                    = 0x2c
	IFLA_BOND_UNSPEC                           = 0x0
	IFLA_BOND_MODE                             = 0x1
	IFLA_BOND_ACTIVE_SLAVE                     = 0x2
	IFLA_BOND_MIIMON                           = 0x3
	IFLA_BOND_UPDELAY                          = 0x4
	IFLA_BOND_DOWNDELAY                        = 0x5
	IFLA_BOND_USE_CARRIER                      = 0x6
	IFLA_BOND_ARP_INTERVAL                     = 0x7
	IFLA_BOND_ARP_IP_TARGET                    = 0x8
	IFLA_BOND_ARP_VALIDATE                     = 0x9
	IFLA_BOND_ARP_ALL_TARGETS                  = 0xa
	IFLA_BOND_PRIMARY                          = 0xb
	IFLA_BOND_PRIMARY_RESELECT                 = 0xc
	IFLA_BOND_FAIL_OVER_MAC                    = 0xd
	IFLA_BOND_XMIT_HASH_POLICY                 = 0xe
	IFLA_BOND_RESEND_IGMP                      = 0xf
	IFLA_BOND_NUM_PEER_NOTIF                   = 0x10
	IFLA_BOND_ALL_SLAVES_ACTIVE                = 0x11
	IFLA_BOND_MIN_LINKS                        = 0x12
	IFLA_BOND_LP_INTERVAL                      = 0x13
	IFLA_BOND_PACKETS_PER_SLAVE                = 0x14
	IFLA_BOND_AD_LACP_RATE                     = 0x15
	IFLA_BOND_AD_SELECT                        = 0x16
	IFLA_BOND_AD_INFO                          = 0x17
	IFLA_BOND_AD_ACTOR_SYS_PRIO                = 0x18
	IFLA_BOND_AD_USER_PORT_KEY                 = 0x19
	IFLA_BOND_AD_ACTOR_SYSTEM                  = 0x1a
	IFLA_BOND_TLB_DYNAMIC_LB                   = 0x1b
	IFLA_BOND_PEER_NOTIF_DELAY                 = 0x1c
	IFLA_BOND_AD_LACP_ACTIVE                   = 0x1d
	IFLA_BOND_MISSED_MAX                       = 0x1e
	IFLA_BOND_NS_IP6_TARGET                    = 0x1f
	IFLA_BOND_AD_INFO_UNSPEC                   = 0x0
	IFLA_BOND_AD_INFO_AGGREGATOR               = 0x1
	IFLA_BOND_AD_INFO_NUM_PORTS                = 0x2
	IFLA_BOND_AD_INFO_ACTOR_KEY                = 0x3
	IFLA_BOND_AD_INFO_PARTNER_KEY              = 0x4
	IFLA_BOND_AD_INFO_PARTNER_MAC              = 0x5
	IFLA_BOND_SLAVE_UNSPEC                     = 0x0
	IFLA_BOND_SLAVE_STATE                      = 0x1
	IFLA_BOND_SLAVE_MII_STATUS                 = 0x2
	IFLA_BOND_SLAVE_LINK_FAILURE_COUNT         = 0x3
	IFLA_BOND_SLAVE_PERM_HWADDR                = 0x4
	IFLA_BOND_SLAVE_QUEUE_ID                   = 0x5
	IFLA_BOND_SLAVE_AD_AGGREGATOR_ID           = 0x6
	IFLA_BOND_SLAVE_AD_ACTOR_OPER_PORT_STATE   = 0x7
	IFLA_BOND_SLAVE_AD_PARTNER_OPER_PORT_STATE = 0x8
	IFLA_BOND_SLAVE_PRIO                       = 0x9
	IFLA_BROADCAST                             = 0x2
	IFLA_IFNAME                                = 0x3
	IFLA_MTU                                   = 0x4
	IFLA_LINK                                  = 0x5
	IFLA_QDISC                                 = 0x6
	IFLA_OPERSTATE                             = 0x10
	IFLA_STATS                                 = 0x7
	IFLA_STATS64                               = 0x17
	IFLA_TXQLEN                                = 0xd
	IFLA_GROUP                                 = 0x1b
	IFLA_LINKINFO                              = 0x12
	IFLA_LINKMODE                              = 0x11
	IFLA_IFALIAS                               = 0x14
	IFLA_PROP_LIST                             = 0x34
	IFLA_ALT_IFNAME                            = 0x35
	IFLA_MASTER                                = 0xa
	IFLA_CARRIER                               = 0x21
	IFLA_CARRIER_CHANGES                       = 0x23
	IFLA_CARRIER_UP_COUNT                      = 0x2f
	IFLA_CARRIER_DOWN_COUNT                    = 0x30
	IFLA_PHYS_PORT_ID                          = 0x22
	IFLA_PHYS_SWITCH_ID                        = 0x24
	IFLA_PHYS_PORT_NAME                        = 0x26
	IFLA_INFO_KIND                             = 0x1
	IFLA_INFO_SLAVE_KIND                       = 0x4
	IFLA_INFO_DATA                             = 0x2
	IFLA_INFO_SLAVE_DATA                       = 0x5
	IFLA_NET_NS_PID                            = 0x13
	IFLA_NET_NS_FD                             = 0x1c
	IFLA_VLAN_UNSPEC                           = 0x0
	IFLA_VLAN_ID                               = 0x1
	IFLA_VLAN_FLAGS                            = 0x2
	IFLA_VLAN_EGRESS_QOS                       = 0x3
	IFLA_VLAN_INGRESS_QOS                      = 0x4
	IFLA_VLAN_PROTOCOL                         = 0x5
	IFLA_VLAN_QOS_UNSPEC                       = 0x0
	IFLA_VLAN_QOS_MAPPING                      = 0x1
	IFLA_MACVLAN_UNSPEC                        = 0x0
	IFLA_MACVLAN_MODE                          = 0x1
	IFLA_MACVLAN_FLAGS                         = 0x2
	IFLA_MACVLAN_MACADDR_MODE                  = 0x3
	IFLA_MACVLAN_MACADDR                       = 0x4
	IFLA_MACVLAN_MACADDR_DATA                  = 0x5
	IFLA_MACVLAN_MACADDR_COUNT                 = 0x6
	IFLA_MACVLAN_BC_QUEUE_LEN                  = 0x7
	IFLA_MACVLAN_BC_QUEUE_LEN_USED             = 0x8
	IFLA_MACVLAN_BC_CUTOFF                     = 0x9
	IFLA_NETKIT_UNSPEC                         = 0x0
	IFLA_NETKIT_PEER_INFO                      = 0x1
	IFLA_NETKIT_PRIMARY                        = 0x2
	IFLA_NETKIT_POLICY                         = 0x3
	IFLA_NETKIT_PEER_POLICY                    = 0x4
	IFLA_NETKIT_MODE                           = 0x5
	IFLA_VXLAN_UNSPEC                          = 0x0
	IFLA_VXLAN_ID                              = 0x1
	IFLA_VXLAN_GROUP                           = 0x2
	IFLA_VXLAN_LINK                            = 0x3
	IFLA_VXLAN_LOCAL                           = 0x4
	IFLA_VXLAN_TTL                             = 0x5
	IFLA_VXLAN_TOS                             = 0x6
	IFLA_VXLAN_LEARNING                        = 0x7
	IFLA_VXLAN_AGEING                          = 0x8
	IFLA_VXLAN_LIMIT                           = 0x9
	IFLA_VXLAN_PORT_RANGE                      = 0xa
	IFLA_VXLAN_PROXY                           = 0xb
	IFLA_VXLAN_RSC                             = 0xc
	IFLA_VXLAN_L2MISS                          = 0xd
	IFLA_VXLAN_L3MISS                          = 0xe
	IFLA_VXLAN_PORT                            = 0xf
	IFLA_VXLAN_GROUP6                          = 0x10
	IFLA_VXLAN_LOCAL6                          = 0x11
	IFLA_VXLAN_UDP_CSUM                        = 0x12
	IFLA_VXLAN_UDP_ZERO_CSUM6_TX               = 0x13
	IFLA_VXLAN_UDP_ZERO_CSUM6_RX               = 0x14
	IFLA_VXLAN_REMCSUM_TX                      = 0x15
	IFLA_VXLAN_REMCSUM_RX                      = 0x16
	IFLA_VXLAN_GBP                             = 0x17
	IFLA_VXLAN_REMCSUM_NOPARTIAL               = 0x18
	IFLA_VXLAN_COLLECT_METADATA                = 0x19
	IFLA_VXLAN_LABEL                           = 0x1a
	IFLA_VXLAN_GPE                             = 0x1b
	IFLA_VXLAN_TTL_INHERIT                     = 0x1c
	IFLA_VXLAN_DF                              = 0x1d
	IFLA_VXLAN_VNIFILTER                       = 0x1e
	IFLA_VXLAN_LOCALBYPASS                     = 0x1f
	IFLA_VXLAN_LABEL_POLICY                    = 0x20
	IFLA_XDP                                   = 0x2b
	IFLA_XDP_FD                                = 0x1
	IFLA_XDP_ATTACHED                          = 0x2
	IFLA_XDP_FLAGS                             = 0x3
	IFLA_XDP_PROG_ID                           = 0x4
	IFLA_XDP_EXPECTED_FD                       = 0x8
	XDP_FLAGS_DRV_MODE                         = 0x4
	XDP_FLAGS_SKB_MODE                         = 0x2
	XDP_FLAGS_HW_MODE                          = 0x8
	XDP_FLAGS_MODES                            = 0xe
	XDP_FLAGS_MASK                             = 0x1f
	XDP_FLAGS_REPLACE                          = 0x10
	XDP_FLAGS_UPDATE_IF_NOEXIST                = 0x1
	LWTUNNEL_ENCAP_MPLS                        = 0x1
	MPLS_IPTUNNEL_DST                          = 0x1
	MPLS_IPTUNNEL_TTL                          = 0x2
	NDA_UNSPEC                                 = 0x0
	NDA_DST                                    = 0x1
	NDA_LLADDR                                 = 0x2
	NDA_CACHEINFO                              = 0x3
	NDA_IFINDEX                                = 0x8
	RTA_UNSPEC                                 = 0x0
	RTA_DST                                    = 0x1
	RTA_ENCAP                                  = 0x16
	RTA_ENCAP_TYPE                             = 0x15
	RTA_PREFSRC                                = 0x7
	RTA_GATEWAY                                = 0x5
	RTA_OIF                                    = 0x4
	RTA_PRIORITY                               = 0x6
	RTA_TABLE                                  = 0xf
	RTA_MARK                                   = 0x10
	RTA_EXPIRES                                = 0x17
	RTA_METRICS                                = 0x8
	RTA_MULTIPATH                              = 0x9
	RTA_PREF                                   = 0x14
	RTAX_ADVMSS                                = 0x8
	RTAX_FEATURES                              = 0xc
	RTAX_INITCWND                              = 0xb
	RTAX_INITRWND                              = 0xe
	RTAX_MTU                                   = 0x2
	NTF_PROXY                                  = 0x8
	RTN_UNICAST                                = 0x1
	RT_TABLE_MAIN                              = 0xfe
	RTPROT_BOOT                                = 0x3
	RTPROT_STATIC                              = 0x4
	RT_SCOPE_UNIVERSE                          = 0x0
	RT_SCOPE_HOST                              = 0xfe
	RT_SCOPE_LINK                              = 0xfd
	RTM_NEWRULE                                = 0x20
	RTM_GETRULE                                = 0x22
	RTM_DELRULE                                = 0x21
	FRA_UNSPEC                                 = 0x0
	FRA_DST                                    = 0x1
	FRA_SRC                                    = 0x2
	FRA_IIFNAME                                = 0x3
	FRA_GOTO                                   = 0x4
	FRA_UNUSED2                                = 0x5
	FRA_PRIORITY                               = 0x6
	FRA_UNUSED3                                = 0x7
	FRA_UNUSED4                                = 0x8
	FRA_UNUSED5                                = 0x9
	FRA_FWMARK                                 = 0xa
	FRA_FLOW                                   = 0xb
	FRA_TUN_ID                                 = 0xc
	FRA_SUPPRESS_IFGROUP                       = 0xd
	FRA_SUPPRESS_PREFIXLEN                     = 0xe
	FRA_TABLE                                  = 0xf
	FRA_FWMASK                                 = 0x10
	FRA_OIFNAME                                = 0x11
	FRA_PAD                                    = 0x12
	FRA_L3MDEV                                 = 0x13
	FRA_UID_RANGE                              = 0x14
	FRA_PROTOCOL                               = 0x15
	FRA_IP_PROTO                               = 0x16
	FRA_SPORT_RANGE                            = 0x17
	FRA_DPORT_RANGE                            = 0x18
	NETKIT_NEXT                                = -0x1
	NETKIT_PASS                                = 0x0
	NETKIT_DROP                                = 0x2
	NETKIT_REDIRECT                            = 0x7
	NETKIT_L2                                  = 0x0
	NETKIT_L3                                  = 0x1
	CLONE_NEWNET                               = 0x40000000
	O_RDONLY                                   = 0x0
	O_CLOEXEC                                  = 0x80000
	NUD_NONE                                   = 0x0
	NUD_NOARP                                  = 0x40
)

func Unshare(_ int) error {
	return nil
}

func Gettid() int {
	return 0
}
