"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GdefAttachmentPointList = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ImpLib = require("@ot-builder/common-impl");
const errors_1 = require("@ot-builder/errors");
const primitive_1 = require("@ot-builder/primitive");
const coverage_1 = require("../shared/coverage");
exports.GdefAttachmentPointList = {
    ...(0, bin_util_1.Read)((view, gOrd) => {
        const gidCov = view.ptr16().next(coverage_1.GidCoverage);
        const glyphCount = view.uint16();
        errors_1.Assert.SizeMatch("AttachList::glyphCount", glyphCount, gidCov.length);
        const atp = new Map();
        for (const gid of gidCov) {
            const pAttachPoint = view.ptr16();
            const pointCount = pAttachPoint.uint16();
            const pointIndices = pAttachPoint.array(pointCount, primitive_1.UInt16);
            atp.set(gOrd.at(gid), pointIndices.map(z => ({ pointIndex: z })));
        }
        return atp;
    }),
    ...(0, bin_util_1.Write)((frag, atl, cfg, gOrd) => {
        const trick = cfg.layout.gdefWriteTrick || 0;
        const { gidList, values: points } = coverage_1.CovUtils.splitListFromMap(atl, gOrd);
        frag.ptr16New().push(coverage_1.GidCoverage, gidList, trick);
        frag.uint16(gidList.length);
        for (const [gid, pl] of ImpLib.Iterators.ZipWithIndex(gidList, points)) {
            const frAttPoint = frag.ptr16New();
            frAttPoint.uint16(pl.length);
            for (const z of pl)
                frAttPoint.uint16(z.pointIndex);
        }
    })
};
//# sourceMappingURL=attachment-point.js.map