#!/usr/bin/env python3

import importlib.util
import os

from fenrirscreenreader.core.i18n import _

# Load base configuration class
_base_path = os.path.join(os.path.dirname(__file__), "..", "config_base.py")
_spec = importlib.util.spec_from_file_location("config_base", _base_path)
_module = importlib.util.module_from_spec(_spec)
_spec.loader.exec_module(_module)
config_command = _module.config_command


class command(config_command):
    def __init__(self):
        super().__init__()

    def get_description(self):
        return "Toggle exclusive keyboard access"

    def run(self):
        current_state = self.getBooleanSetting("keyboard", "grabDevices", True)
        new_state = self.toggleBooleanSetting("keyboard", "grabDevices")

        if new_state != current_state:
            state_text = "enabled" if new_state else "disabled"
            self.present_text(f"Exclusive keyboard access {state_text}")
            if new_state:
                self.present_text(
                    "Fenrir will have exclusive control of keyboard input"
                )
            else:
                self.present_text(
                    "Fenrir will share keyboard input with other applications"
                )
            self.present_text(
                "Please restart Fenrir for this change to take effect"
            )
            self.play_sound("Accept")
        else:
            self.present_text("Failed to change keyboard grab setting")
            self.play_sound("Error")
