﻿/* This test validates .NET preserves the OpenSSL 3.2 behavior introduced in
   https://github.com/openssl/openssl/pull/13817.
   This change is backported to earlier OpenSSL versions in the Red Hat/Fedora distributions. */

using System.Security.Cryptography;

/* The data used in this test was generated using https://github.com/tomato42/marvin-toolkit/.
   The data has PKCS padding errors. Instead of returning an error code for the padding errors,
   OpenSSL returns success with data. */

string key = @"
-----BEGIN PRIVATE KEY-----
MIIEugIBADANBgkqhkiG9w0BAQEFAASCBKQwggSgAgEAAoIBAQCYLqFvySu5mYTS
j4yveQz0PAM4AQOdtCLriXUk6KVq0Q+sb0CxZ/L6S+KxNHIV46idUnNnihWRLdlU
MWG6Q0b7vKx58c8KGVZT51AUHaXyqbNFbh60ho8lPHIkrJxYw9Q22t2MIgb8pEgh
8yF6Z1aelSuZ8SC9rojhqUykaBG/oVwqaT6QG1lrS6gQx/glVbPv88ubUd6lSwMz
R2RwvhCTGMZFZDL3FP5ZmU2A6tQreLcC+3OloLoFDwzHkvrGBxhouEDuhmB91JHk
Erf+SUxY6gOV1hTuM6txnwZeOrJvGmrUaOsjT2cnvwDCun1KV+6tiQQlGmah7zMu
ST/km7RPAgMBAAECggEABs3sjVuz1xhS2yCGNe3vxj3Z5DFB0NVvy3ms1La+qrOC
HWYnp0CfTLfqGp1Ezc8myDEz4SwutOKVbJFjer+svVXDna8FRsDSRNPuly+qLo4n
t163BCbEelg+peTxfeCOE3PR/LfxLKIV0MeW6betvk9FXbYHDj273hP2GtKSZ8lR
qbP5UX+iRdPj2GThni4OWcN+lgszUyYb+yEAI8/JnNcISZjNFghjBuE8/Il3/Iww
Zuca5PWiDy5SBWeqYf+8Llz8wnJPT7IyBAMQfFRU77Eeqz3F/v9D5J+BGOjQDUDl
hWvgtc0sGI7n1tGRbGpZYTQo69mCHXkUVBTaL64yDQKBgQDKE9b4uRq8tB/2f+pW
AyS3x8UXewnPikWyMQqC7WZmPTvTKqePvF04XUznCQxujO6YRmSM2/avI63SNDKo
RhqPeW5wXg9jlqIFmYL1k0trjH0cbPuKBwxJtJT7TtFN5M9A+jNgPvt385sGXXyO
U1ebdaEcBD68TOlLoIE8orQNowKBgQDAymD7DzmF4dVUL1TQH/dC9EsnRqlHhTLo
m0X4Kkyy/Z0cbLOvNDG34Rr5IrGT4GnVx85nTUqxW7UUZ5CZpH4Z2kw5U8AJLVc2
mJ9IuMLDNOOmeHs+YltLNWHQqmAcA6vwEaHjMQr8iFmDsXK27EIMedOcMQj+DcUt
VYnkRFORZQJ/E7vcQm3RLpxogqn7OGsWKtxXYvOhAaN/KuefHyoP1ewk63o+4sqC
T/7Mg8Nec21P348AQsE4VeImF2EBkW1HKruxDUgiOJd9Ow7CuzinJNmTXjNGXTRS
/t+jrOcFiZXOp4nHep6r8AraGMUIZN2+sG/MS/AeMEVSgxApjsJU0wKBgDTdifhu
NVTcF3ZtQDGOAmyOtqj/fF3LTalxIp+pYbzXRKTNvfv2MQf+JzpX5B/rsrnXf2be
T/QQdLgyqfknnRiTvsEdkRQzJa4n7c2wNF/4+c/lS85QhD48ViU1AwPLkfNTsnOt
OBkFfp5ZI167rGTlZzx2ScP4nLAQu64nek7tAoGACZ6TelILDOS9JKtUMymGK/mk
0rxTwxTNyaerAwRHIRFDtgoYpUlNyb0yHT3Gdd6iLYQv/PvKfJ8mM3oJp5we/WMy
FEPrfydLbz5+DhdgK235US5yIlegtvTFR9qLQFwEx7livneBjfa7OI2GmvS9pRPk
PsuFb/qC2D8QszN3eAI=
-----END PRIVATE KEY-----";

byte[] data = new[]
{
0x70, 0x84, 0xab, 0x58, 0x44, 0x70, 0xf5, 0x55, 0x48, 0x3c, 0x06, 0xaa, 0x5f, 0x73, 0xda, 0x05,
0x81, 0xf7, 0x4f, 0x4c, 0x9f, 0xfa, 0xa2, 0xf9, 0x8a, 0xae, 0xd6, 0xf5, 0xbe, 0x17, 0x2e, 0x1c,
0x55, 0x6a, 0xd8, 0x73, 0x53, 0xdf, 0x5b, 0xa7, 0x5d, 0x09, 0xb8, 0x81, 0x3e, 0xf3, 0x16, 0x77,
0x23, 0xc1, 0x09, 0x16, 0xa5, 0x4d, 0x96, 0xff, 0xb4, 0xd5, 0xef, 0x7d, 0xc1, 0x5d, 0x8f, 0xc1,
0x75, 0x8b, 0x3c, 0xe0, 0xc8, 0xaf, 0xeb, 0xca, 0x0e, 0x46, 0x2b, 0x06, 0x8b, 0xf5, 0x3e, 0xb7,
0xa4, 0xf1, 0xec, 0xb4, 0x80, 0x2d, 0x6f, 0xd8, 0xa9, 0x63, 0xca, 0x3e, 0x60, 0x12, 0xae, 0x89,
0x59, 0x1e, 0xd3, 0x9e, 0x97, 0x78, 0x86, 0x2a, 0x49, 0xca, 0x55, 0x6d, 0xb8, 0xd5, 0x40, 0xbc,
0x31, 0x05, 0x2a, 0x2a, 0x7d, 0x77, 0x27, 0x53, 0xd8, 0xe8, 0xae, 0x89, 0xad, 0x80, 0x56, 0x08,
0x49, 0x5f, 0xf5, 0xa6, 0xe8, 0x58, 0x8f, 0x39, 0x58, 0xfe, 0xc2, 0x83, 0xb7, 0x88, 0x82, 0xb7,
0x90, 0x71, 0xe2, 0xd6, 0xbe, 0x2d, 0x93, 0x91, 0xb3, 0x2c, 0x9b, 0x27, 0xf5, 0x1d, 0xb8, 0xe5,
0x2d, 0x6a, 0xd9, 0x77, 0xbc, 0xc7, 0xb7, 0x09, 0xa6, 0x41, 0xc0, 0x57, 0xd1, 0xeb, 0x19, 0x7f,
0xe6, 0x61, 0x62, 0x54, 0xd9, 0x91, 0x6c, 0x3e, 0x76, 0x64, 0xb5, 0xa8, 0xcc, 0x8e, 0x0c, 0xdf,
0xbd, 0xec, 0x9b, 0xab, 0x55, 0xc6, 0x0b, 0x29, 0xa8, 0xc6, 0x72, 0xbf, 0xcb, 0x58, 0xda, 0x4d,
0x0e, 0x1a, 0x34, 0xd4, 0xc9, 0x93, 0x97, 0xce, 0xbc, 0x19, 0x50, 0xb3, 0x4b, 0xf2, 0xf9, 0x1f,
0x2e, 0x62, 0xbf, 0xf2, 0x5f, 0x50, 0xce, 0x89, 0x64, 0xd5, 0x54, 0xcc, 0xc4, 0x49, 0x57, 0xfa,
0x48, 0x7f, 0x19, 0x82, 0x17, 0x2b, 0xeb, 0x7e, 0x22, 0x6b, 0xd9, 0xf7, 0x77, 0x3e, 0xce, 0x72,
}.Select(i => (byte)i).ToArray();

byte[] expected = new[]
{
0x38, 0xd2, 0x12, 0xd1, 0xef, 0xd2, 0x4d, 0x28, 0x99, 0x3e, 0x07, 0x0d, 0x7b, 0xb2, 0x8b, 0xe7,
0x4f, 0x8c, 0xbe, 0x68, 0x9e, 0x29, 0x01, 0x14, 0xd6, 0x08, 0x73, 0x67, 0x34, 0x3e, 0xed, 0x03,
0x6c, 0x08, 0x01, 0x75, 0x4e, 0xea, 0xcf, 0x1f, 0x98, 0xdd, 0x3b, 0x82, 0x78, 0x3c, 0xaf, 0x74,
0x56, 0xf2, 0xab, 0xd8, 0x2c, 0xe9, 0xe6, 0xcd, 0x1d, 0x61, 0xc9, 0x77, 0xfc, 0x71, 0x14, 0x9c,
0x9d, 0x53, 0xfc, 0xf4, 0xfc, 0x4a, 0x4d, 0xff, 0x93, 0x96, 0x08, 0xb8, 0x90, 0x83, 0xad, 0xfa,
0x73, 0x87, 0xeb, 0xbe, 0x28, 0x21, 0xae, 0x8d, 0xa8, 0xca, 0x79, 0xff, 0x38, 0xa2, 0x26, 0x67,
0xd4, 0x91, 0x05, 0x34, 0x1b, 0x02, 0xea, 0x11, 0x02, 0x60, 0xe9, 0x4d, 0x5c, 0xfd, 0x14, 0x7a,
0xbf, 0xfc, 0xff, 0xe9, 0x5b, 0x08, 0x6e, 0x10, 0x9a, 0x1d, 0xdf,
}.Select(i => (byte)i).ToArray();

using RSA rsa = RSA.Create();
rsa.ImportFromPem(key);

byte[] decrypted;
try
{
    decrypted = rsa.Decrypt(data, RSAEncryptionPadding.Pkcs1);
}
catch (Exception ex)
{
    Console.WriteLine("FAIL: RSA decryption threw an exception:");
    Console.WriteLine(ex);
    return 1;
}

if (!expected.AsSpan().SequenceEqual(decrypted))
{
    Console.WriteLine("FAIL: decrypted data does not match the expected value from OpenSSL:");
    Console.WriteLine($"Actual:   {string.Join("", decrypted.Select(b => b.ToString("x2")))}");
    Console.WriteLine($"Expected: {string.Join("", expected.Select(b => b.ToString("x2")))}");
    return 1;
}


Console.WriteLine("PASS: .NET RSA+PKCS API matches OpenSSL behavior.");
return 0;
